	% EXAMPLE 9.22 Differentiator
	%
	% 	Determine poles and zeros for a differentiator	
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2008-07-12
	% 	Modified by: 	 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:			 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	clear global
	clear all
	close all	
	global FX LDT Dmin NF NL V Q0 Q1 QA QB QC QD0 QD1 QF1 Tol Tol1 H X
	global p Des wT Nz Np
	wcT = 1*pi;
	
	P = [-0.67 -0.13];
	Z = [1 -0.62];
	G = 1;
	
	%	P = [-0.142403 -0.7169867];
	%%	Z = [1 -0.67082621];
	%	G = 0.36637364;	
	Nz = length(Z);
	Np = length(P);
	N = Nz+Np+1;	% Number of parameters
	
	% Convert G, Z, P to optimization parameters	
	X = PZ_2_X_PARAMETERS(G, Z, P);	
	wT = [0:0.01:1]*wcT;
	Des = wT/pi;	% Desired magnitude response
	p = 2;
	h = 1; Tol = 10^-15; Print = 0; Fmin = 0; SCBD = 2; KTM = 4; ILLC = (1==0);	
	for k = 1:5
		[X, Cost] = PRAXIS('COST_DIFF_Z_fun', N, h, Print, ILLC, SCBD, KTM, Fmin);
		[G, Z, P] = X_2_PZ(X); 
		% Make minimum-phase
		 
		% Flip any poles outside the unit circle
		 
	end

	[G, Z, P] = X_2_PZ(X)
	figure(1)
	PLOT_PZ_Z(Z, P)
	
	figure(2)
	H = PZ_2_FREQ_Z(G, Z, P, wT);
	subplot('position', [0.11 0.4 0.88 0.5]);	
 
	PLOT_DEVIATION_Z(wT, abs(H)-Des)
 
		figure(3)
		Phase = PZ_2_PHASE_Z(G, Z, P, wT);
		subplot('position', [0.1 0.4 0.88 0.5]);
		PLOT_PHASE_Z(wT, Phase, 0, pi/2)
		hold on
		PLOT_PHASE_Z(wT, (pi-wT)/2, 0, pi/2)
	
		text(0.3, 0.4,'Ideal differentiator','FontName','Times','FontSize',16);
		line([1.05 1.3],[0.5 0.9])
	
	%=======
	% Steiglitz	
	%	P = [-0.142403 -0.7169867];
	%	Z = [1 -0.67082621];
	%	G = 0.36637364;
	
	%	H1 = PZ_2_FREQ_Z(G, Z, P, wT); 
	%	plot(wT, abs(H1)-Des,'linewidth',1)	
